<?php
    defined('BASEPATH') OR exit('No direct script access allowed');
    class Accounts extends MY_Controller {
	function __construct(){
            parent::__construct();
            if($this->session->user == "") {
                redirect('login');
            }
            $this->load->model('finance/AccountModel');
            $this->load->library('Formatslist');
	}
	public function index(){
            $this->session->unset_userdata('editaccID');
            $accounts = $this->AccountModel->all_accounts();
            $data["accounts"]   =   $accounts;
            $data['template'] = 'finance/view_accounts';
            $this->load->view('template',$data);
	}
	public function add_account($id=0){
            $id = $this->session->user;
            if(!empty($_POST)){
                if($this->input->post('available_balance')==''){
                    $available_balance = $this->input->post('initial_balance');
                    $data =  array('account_name' => $this->input->post('account_name'),
                        'account_number' => $this->input->post('account_number'),
                        'initial_balance' => $this->input->post('initial_balance'),
                        'available_balance' => $available_balance,
                    );
                    $data['ID'] = uniqid();
                    $this->AccountModel->add_account($data);
                }else{
                    $id = $this->input->post('id');
                    $data =  array(
                        'account_name' => $this->input->post('account_name'),
                        'account_number' => $this->input->post('account_number'),
                        'initial_balance' => $this->input->post('initial_balance')
//                        'available_balance' => $this->input->post('available_balance'),
                    );
                    //$this->AccountModel->update_account($id, $ownerid, $data);
                    $this->AccountModel->update_account($id, $data);
                }
                redirect('finance/accounts');
            } else {
                $id = $this->session->userdata('editaccID');
                $data = [];
                if ($id){
                    $account = $this->AccountModel->get_account($id);
                    $data['account'] = $account[0];
                }
                $this->load->view('common/head');
                $this->load->view('common/header');
                $this->load->view('finance/add_account', $data);
                $this->load->view('common/footer');
            }
	}

	public function delete_accounts($id=''){
            $where = array('ID' => $id);  
            if($this->common->delete('ACCOUNTS',$where)){
                $this->session->set_flashdata('success_msg', 'The record has been deleted successfuly.');
                redirect('finance/accounts');
            }else{
                $this->session->set_flashdata('success_msg', 'Cannot Delete');
                redirect('finance/accounts');
            }
	}
        
        public function editAccount($id=''){
            $this->session->set_userdata(array('editaccID'  => $id));
            redirect("finance/accounts/add_account");
        }
        
}
