<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payheads extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct(){
		parent::__construct();
		if($this->session->username == "")
        {
            redirect('login');
        }
		$this->load->model('PayheadModel','PayheadModel');

	}
	public function index()
	{
		$this->load->view('templates/header');
		$this->load->view('templates/sidebar-menu');
		$this->load->view('employee/view_payheads');
		$this->load->view('templates/footer');
	}

	public function view_payheads(){
		$ownerid=$this->session->userid;

		$columns = array( 
                            0 =>'id', 
							1 =>'checkbox',
                            2 =>'name',
                            3 =>'payhead_type',
                        );

		$limit = $this->input->post('length');
        $start = $this->input->post('start');
        $order = $columns[$this->input->post('order')[0]['column']];
        $dir = $this->input->post('order')[0]['dir'];
  

        $totalData = $this->PayheadModel->all_payheads_count();
            
        $totalFiltered = $totalData; 

		$search_array = array();  
        if(!empty($this->input->post('search')['value'])&&!empty($this->input->post('search_btn'))){
            $search_array['search'] = $this->input->post('search')['value'];
        }
            
        if(count($search_array)==0)
        {            
            $payheads = $this->PayheadModel->all_payheads($limit,$start,$order,$dir);
        }else {

            $payheads =  $this->PayheadModel->payheads_search($limit,$start,$search_array,$order,$dir, $ownerid);

            $totalFiltered = $this->PayheadModel->payheads_search_count($search_array, $ownerid);
        }

        $data = array();
        if(!empty($payheads))
        {
            foreach ($payheads as $payhead)
            {

                $nestedData['id'] = $payhead->id;
				$nestedData['checkbox'] = '';
                $nestedData['name'] = $payhead->name;
                $nestedData['payhead_type'] = $payhead->payhead_type;

                $data[] = $nestedData;

            }
        }
          
        $json_data = array(
                    "draw"            => intval($this->input->post('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
            
        echo json_encode($json_data); 
	}

	public function add_payhead($id=0)
	{
		$ownerid = $this->session->userid;
		if(!empty($_POST))
		{
			if($this->input->post('id')==''){
			
				$data =  array('name' => $this->input->post('name'),
						'payhead_type' => $this->input->post('payhead_type')
						);
				$data['ownerid'] = $ownerid;
				$data['created_by'] = $this->session->userid;
				//test

				$this->PayheadModel->add_payhead($data);
			}else{
				$id = $this->input->post('id');
				$data =  array(
						'name' => $this->input->post('name'),
						'payhead_type' => $this->input->post('payhead_type'),
						);
				$this->PayheadModel->update_payhead($id, $ownerid, $data);
			}
			redirect('payheads');
		}
		else
		{
			$data = [];
			if ($id!=0){
				$payhead = $this->PayheadModel->get_payhead($id, $ownerid);
				$data['payhead'] = $payhead[0];
			}
			$this->load->view('templates/header');
			$this->load->view('templates/sidebar-menu');
			$this->load->view('employee/add_payhead', $data);
			$this->load->view('templates/footer');
		}

		
	}

	public function delete_payheads(){

		if(!empty($_POST))
		{
			$ids = $this->input->post('id');
			$this->PayheadModel->delete_payheads($ids);

			redirect('payheads');
		}
	}


}
