<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Leaves extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct(){
		parent::__construct();
		if($this->session->username == "")
        {
            redirect('login');
        }
		$this->load->model('LeaveModel','LeaveModel');

	}
	public function index()
	{
		$this->load->view('templates/header');
		$this->load->view('templates/sidebar-menu');
		$this->load->view('employee/view_leaves');
		$this->load->view('templates/footer');
	}

	public function view_leaves(){
		$ownerid=$this->session->userid;

		$columns = array( 
                            0 =>'id', 
							1 =>'checkbox',
                            2 =>'leave_type',
                            3 =>'leave_number',
							4 =>'id'
                        );

		$limit = $this->input->post('length');
        $start = $this->input->post('start');
        $order = $columns[$this->input->post('order')[0]['column']];
        $dir = $this->input->post('order')[0]['dir'];
  

        $totalData = $this->LeaveModel->all_leaves_count();
            
        $totalFiltered = $totalData; 

		$search_array = array();  
        if(!empty($this->input->post('search')['value'])&&!empty($this->input->post('search_btn'))){
            $search_array['search'] = $this->input->post('search')['value'];
        }
            
        if(count($search_array)==0)
        {            
            $leaves = $this->LeaveModel->all_leaves($limit,$start,$order,$dir);
        }else {

            $leaves =  $this->LeaveModel->leaves_search($limit,$start,$search_array,$order,$dir, $ownerid);

            $totalFiltered = $this->LeaveModel->leaves_search_count($search_array, $ownerid);
        }

        $data = array();
        if(!empty($leaves))
        {
            foreach ($leaves as $leave)
            {

                $nestedData['id'] = $leave->id;
				$nestedData['checkbox'] = '';
                $nestedData['leave_type'] = $leave->leave_type;
                $nestedData['leave_number'] = $leave->leave_number;
				$nestedData['id'] = $leave->id;

                $data[] = $nestedData;

            }
        }
          
        $json_data = array(
                    "draw"            => intval($this->input->post('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
            
        echo json_encode($json_data); 
	}

	public function add_leave($id=0)
	{
		$ownerid = $this->session->userid;
		if(!empty($_POST))
		{
			if($this->input->post('id')==''){
			
				$data = array('leave_type' => $this->input->post('leave_type'),
							'leave_number' => $this->input->post('leave_number'),
							'description' => $this->input->post('description'),
						);

				if(!empty($this->input->post('paid'))){
					$data['paid'] = 1;
				}else{
					$data['paid'] = 0;
				}

				if(!empty($this->input->post('carry_leave'))){
					$data['carry_leave'] = 1;
				}else{
					$data['carry_leave'] = 0;
				}
				$leave_params = array();

				if (!empty($this->input->post('param_id'))){
					$param_ids = $this->input->post('param_id');
				}else {
					$param_ids = array();
				}
				
				
				foreach ($param_ids as $param_id){
					$param = array();
					$param['title'] = $this->input->post('title'.$param_id);
					$param['start_date'] = $this->input->post('start_date'.$param_id);
					$param['end_date'] = $this->input->post('end_date'.$param_id);
					if(!empty($this->input->post('optional'.$param_id))){
						$param['optional'] = 1;
					}else{
						$param['optional'] = 0;
					}
					array_push($leave_params, $param);					

				}
				$data['leave_params'] = json_encode($leave_params);
				$data['ownerid'] = $ownerid;
				$data['created_by'] = $this->session->userid;
				//test

				$this->LeaveModel->add_leave($data);
			}else{
				$id = $this->input->post('id');
				$data = array('leave_type' => $this->input->post('leave_type'),
							'leave_number' => $this->input->post('leave_number'),
							'description' => $this->input->post('description'),
						);

				if(!empty($this->input->post('paid'))){
					$data['paid'] = 1;
				}else{
					$data['paid'] = 0;
				}

				if(!empty($this->input->post('carry_leave'))){
					$data['carry_leave'] = 1;
				}else{
					$data['carry_leave'] = 0;
				}

				$leave_params = array();

				if (!empty($this->input->post('param_id'))){
					$param_ids = $this->input->post('param_id');
				}else {
					$param_ids = array();
				}
				
				foreach ($param_ids as $param_id){
					$param = array();
					$param['title'] = $this->input->post('title'.$param_id);
					$param['start_date'] = $this->input->post('start_date'.$param_id);
					$param['end_date'] = $this->input->post('end_date'.$param_id);
					if(!empty($this->input->post('optional'.$param_id))){
						$param['optional'] = 1;
					}else{
						$param['optional'] = 0;
					}
					array_push($leave_params, $param);					

				}
				$data['leave_params'] = json_encode($leave_params);
				$this->LeaveModel->update_leave($id, $ownerid, $data);
			}
			redirect('leaves');
		}
		else
		{
			$data = [];
			if ($id!=0){
				$leave = $this->LeaveModel->get_leave($id, $ownerid);
				$data['leave'] = $leave[0];
			}
			$this->load->view('templates/header');
			$this->load->view('templates/sidebar-menu');
			$this->load->view('employee/add_leave', $data);
			$this->load->view('templates/footer');
		}

		
	}

	public function delete_leaves(){

		if(!empty($_POST))
		{
			$ids = $this->input->post('id');
			$this->LeaveModel->delete_leaves($ids);

			redirect('leaves');
		}
	}


}
