<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employees extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct(){
		parent::__construct();
		if($this->session->username == "")
        {
            redirect('login');
        }
		$this->load->model('EmployeeModel','EmployeeModel');
        $this->load->model('DepartmentModel', 'DepartmentModel');
        $this->load->model('DesignationModel', 'DesignationModel');

	}
	public function index()
	{
        $data['departments'] = $this->DepartmentModel->get_departments();
        $data['designations'] = $this->DesignationModel->get_designations();

		$this->load->view('templates/header');
		$this->load->view('templates/sidebar-menu');
		$this->load->view('employee/view_employees', $data);
		$this->load->view('templates/footer');
	}

	public function view_employees(){
        $ownerid=$this->session->userid;
		$columns = array( 
                            0 =>'userid', 
							1 =>'checkbox',
                            2 =>'name',
                            3 =>'empid',
							4=> 'department',
                            5=> 'designation',
                            6=> 'email',
                            7=> 'ctc',
                            8=> 'send_email'
                        );

		$limit = $this->input->post('length');
        $start = $this->input->post('start');
        $order = $columns[$this->input->post('order')[0]['column']];
        $dir = $this->input->post('order')[0]['dir'];
  

        $totalData = $this->EmployeeModel->all_employees_count();
            
        $totalFiltered = $totalData; 

        $search_array = array();  
        if(!empty($this->input->post('search')['value'])&&!empty($this->input->post('search_btn'))){
            $search_array['search'] = $this->input->post('search')['value'];
        }
        if(!empty($this->input->post('filter_dept'))){
            $search_array['filter_dept'] = $this->input->post('filter_dept');
        }
        if(!empty($this->input->post('filter_desg'))){
            $search_array['filter_desg'] = $this->input->post('filter_desg');
        }
        if(count($search_array)==0)
        {            
            $employees = $this->EmployeeModel->all_employees($limit,$start,$order,$dir);
        }else {
            // $search = $this->input->post('search')['value']; 

            $employees =  $this->EmployeeModel->employees_search($limit,$start,$search_array,$order,$dir, $ownerid);

            $totalFiltered = $this->EmployeeModel->employees_search_count($search_array, $ownerid);
        }

        $data = array();
        if(!empty($employees))
        {
            
            $k = 1;
            foreach ($employees as $row)
            {

                $nestedData['userid'] = $k;
				$nestedData['checkbox'] = $row->userid;
                $nestedData['name'] = $row->name;
                $nestedData['empid'] = $row->empid;
				$nestedData['department'] = $row->department;
                $nestedData['designation'] = $row->designation;
				$nestedData['email'] = $row->email;
                $nestedData['ctc'] = $row->ctc;
                $nestedData['send_email'] = $row->userid;

                $data[] = $nestedData;
                $k++;
            }
        }
          
        $json_data = array(
                    "draw"            => intval($this->input->post('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
            
        echo json_encode($json_data);

	}

    public function add_employee($userid=0)
	{
		$ownerid = $this->session->userid;
		if(!empty($_POST))
		{
			if($this->input->post('userid')==''){
			
				$data =  array('name' => $this->input->post('name'),
						'user_role' => $this->input->post('user_role'),
                        'email' => $this->input->post('email'),
                        'empid' => $this->input->post('empid'),
                        'department' => $this->input->post('department'),
                        'designation' => $this->input->post('designation'),
                        'phone' => $this->input->post('phone'),
                        'blood_group' => $this->input->post('blood_group'),
                        'dob' => $this->input->post('dob'),
                        'present_address' => $this->input->post('present_address'),
                        'permanent_address' => $this->input->post('permanent_address'),
                        'joining_date' => $this->input->post('joining_date'),
                        'work_type' => $this->input->post('work_type'),
                        'payment_type' => $this->input->post('payment_type'),
                        'pan' => $this->input->post('pan'),
                        'pf_ac' => $this->input->post('pf_ac'),
                        'bank_ac' => $this->input->post('bank_ac'),
                        'bank_name' => $this->input->post('bank_name'),
                        'bank_ac' => $this->input->post('bank_ac'),
                        'bank_branch' => $this->input->post('bank_branch'),
                        'ifsc' => $this->input->post('ifsc'),
                        'leaving_date' => $this->input->post('leaving_date'),
                        'created' => $this->input->post('created'),
						);
				if (empty($this->input->post('gender'))){
					$data['gender'] = 0;
				}else{
					$data['gender'] = 1;
				}
				$data['ownerid'] = $ownerid;
				$data['created_by'] = $this->session->userid;
				//test

				$this->EmployeeModel->add_employee($data);
			}else{
				$userid = $this->input->post('userid');
				$data =  array('name' => $this->input->post('name'),
						'user_role' => $this->input->post('user_role'),
                        'email' => $this->input->post('email'),
                        'empid' => $this->input->post('empid'),
                        'department' => $this->input->post('department'),
                        'designation' => $this->input->post('designation'),
                        'phone' => $this->input->post('phone'),
                        'blood_group' => $this->input->post('blood_group'),
                        'dob' => $this->input->post('dob'),
                        'present_address' => $this->input->post('present_address'),
                        'permanent_address' => $this->input->post('permanent_address'),
                        'joining_date' => $this->input->post('joining_date'),
                        'work_type' => $this->input->post('work_type'),
                        'payment_type' => $this->input->post('payment_type'),
                        'pan' => $this->input->post('pan'),
                        'pf_ac' => $this->input->post('pf_ac'),
                        'bank_ac' => $this->input->post('bank_ac'),
                        'bank_name' => $this->input->post('bank_name'),
                        'bank_ac' => $this->input->post('bank_ac'),
                        'bank_branch' => $this->input->post('bank_branch'),
                        'ifsc' => $this->input->post('ifsc'),
                        'leaving_date' => $this->input->post('leaving_date'),
                        'created' => $this->input->post('created'),
						);
				if (empty($this->input->post('gender'))){
					$data['gender'] = 0;
				}else{
					$data['gender'] = 1;
				}
				$this->EmployeeModel->update_employee($userid, $ownerid, $data);
			}
			redirect('employees');
		}
		else
		{
			$data = [];
			if ($userid!=0){
				$employee = $this->EmployeeModel->get_employee($userid, $ownerid);
				$data['employee'] = $employee[0];
			}
            $data['designations'] = $this->DesignationModel->get_designations();
            $data['departments'] = $this->DepartmentModel->get_departments();
            $data['user_roles'] = $this->EmployeeModel->get_roles();

			$this->load->view('templates/header');
			$this->load->view('templates/sidebar-menu');
			$this->load->view('employee/add_employee', $data);
			$this->load->view('templates/footer');
		}

		
	}


}
