<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Designations extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct(){
		parent::__construct();
		if($this->session->username == "")
        {
            redirect('login');
        }
		$this->load->model('DesignationModel','DesignationModel');

	}
	public function index()
	{
		$this->load->view('templates/header');
		$this->load->view('templates/sidebar-menu');
		$this->load->view('employee/view_designations');
		$this->load->view('templates/footer');
	}

	public function view_designations(){
		$ownerid=$this->session->userid;

		$columns = array( 
                            0 =>'id', 
							1 =>'checkbox',
                            2 =>'title',
                            3 => 'published',
							4 => 'id'
                        );

		$limit = $this->input->post('length');
        $start = $this->input->post('start');
        $order = $columns[$this->input->post('order')[0]['column']];
        $dir = $this->input->post('order')[0]['dir'];
  

        $totalData = $this->DesignationModel->all_designations_count();
            
        $totalFiltered = $totalData; 

		$search_array = array();  
        if(!empty($this->input->post('search')['value'])&&!empty($this->input->post('search_btn'))){
            $search_array['search'] = $this->input->post('search')['value'];
        }
        if($this->input->post('filter_status')!==''){
            $search_array['filter_status'] = $this->input->post('filter_status');
        }
            
        if(count($search_array)==0)
        {            
            $designations = $this->DesignationModel->all_designations($limit,$start,$order,$dir);
        }else {

            $designations =  $this->DesignationModel->designations_search($limit,$start,$search_array,$order,$dir, $ownerid);

            $totalFiltered = $this->DesignationModel->designations_search_count($search_array, $ownerid);
        }

        $data = array();
        if(!empty($designations))
        {
            foreach ($designations as $designation)
            {

                $nestedData['id'] = $designation->id;
				$nestedData['checkbox'] = '';
                $nestedData['title'] = $designation->title;
                $nestedData['published'] = $designation->published;
				$nestedData['id'] = $designation->id;

                $data[] = $nestedData;

            }
        }
          
        $json_data = array(
                    "draw"            => intval($this->input->post('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
            
        echo json_encode($json_data); 
	}

	public function add_designation($id=0)
	{
		$ownerid = $this->session->userid;
		if(!empty($_POST))
		{
			if($this->input->post('id')==''){
			
				$data =  array('title' => $this->input->post('title'),
						'description' => $this->input->post('description')
						);
				if (empty($this->input->post('published'))){
					$data['published'] = 0;
				}else{
					$data['published'] = 1;
				}
				$data['ownerid'] = $ownerid;
				$data['created_by'] = $this->session->userid;
				//test

				$this->DesignationModel->add_designation($data);
			}else{
				$id = $this->input->post('id');
				$data =  array(
						'title' => $this->input->post('title'),
						'description' => $this->input->post('description'),
						);
				if (empty($this->input->post('published'))){
					$data['published'] = 0;
				}else{
					$data['published'] = 1;
				}
				$this->DesignationModel->update_designation($id, $ownerid, $data);
			}
			redirect('designations');
		}
		else
		{
			$data = [];
			if ($id!=0){
				$designation = $this->DesignationModel->get_designation($id, $ownerid);
				$data['designation'] = $designation[0];
			}
			$this->load->view('templates/header');
			$this->load->view('templates/sidebar-menu');
			$this->load->view('employee/add_designation', $data);
			$this->load->view('templates/footer');
		}

		
	}

	public function delete_designations(){

		if(!empty($_POST))
		{
			$ids = $this->input->post('id');
			$this->DesignationModel->delete_designations($ids);

			redirect('designations');
		}
	}

	public function update_designation_status(){
		$id = $this->input->post('id');
		$update_status = $this->input->post('published');
		$data = $this->DesignationModel->update_designation_status($id, $update_status);
		echo json_encode($data);
	}

}
