<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Departments extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct(){
		parent::__construct();
		if($this->session->username == "")
        {
            redirect('login');
        }
		$this->load->model('DepartmentModel','DepartmentModel');

	}
	public function index()
	{
		$this->load->view('templates/header');
		$this->load->view('templates/sidebar-menu');
		$this->load->view('employee/view_departments');
		$this->load->view('templates/footer');
	}

	public function view_departments(){
		$ownerid=$this->session->userid;

		$columns = array( 
                            0 =>'id', 
							1 =>'checkbox',
                            2 =>'name',
                            3 => 'published',
							4 => 'id'
                        );

		$limit = $this->input->post('length');
        $start = $this->input->post('start');
        $order = $columns[$this->input->post('order')[0]['column']];
        $dir = $this->input->post('order')[0]['dir'];
  

        $totalData = $this->DepartmentModel->all_departments_count();
            
        $totalFiltered = $totalData; 

		$search_array = array();  
        if(!empty($this->input->post('search')['value'])&&!empty($this->input->post('search_btn'))){
            $search_array['search'] = $this->input->post('search')['value'];
        }
        if($this->input->post('filter_status')!==''){
            $search_array['filter_status'] = $this->input->post('filter_status');
        }
            
        if(count($search_array)==0)
        {            
            $departments = $this->DepartmentModel->all_departments($limit,$start,$order,$dir);
        }else {

            $departments =  $this->DepartmentModel->departments_search($limit,$start,$search_array,$order,$dir, $ownerid);

            $totalFiltered = $this->DepartmentModel->departments_search_count($search_array, $ownerid);
        }

        $data = array();
        if(!empty($departments))
        {
            foreach ($departments as $department)
            {

                $nestedData['id'] = $department->id;
				$nestedData['checkbox'] = '';
                $nestedData['name'] = $department->name;
                $nestedData['published'] = $department->published;
				$nestedData['id'] = $department->id;

                $data[] = $nestedData;

            }
        }
          
        $json_data = array(
                    "draw"            => intval($this->input->post('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
            
        echo json_encode($json_data); 
	}

	public function add_department($id=0)
	{
		$ownerid = $this->session->userid;
		if(!empty($_POST))
		{
			if($this->input->post('id')==''){
			
				$data =  array('name' => $this->input->post('name'),
						'description' => $this->input->post('description')
						);
				if (empty($this->input->post('published'))){
					$data['published'] = 0;
				}else{
					$data['published'] = 1;
				}
				$data['ownerid'] = $ownerid;
				$data['created_by'] = $this->session->userid;
				//test

				$this->DepartmentModel->add_department($data);
			}else{
				$id = $this->input->post('id');
				$data =  array(
						'name' => $this->input->post('name'),
						'description' => $this->input->post('description'),
						);
				if (empty($this->input->post('published'))){
					$data['published'] = 0;
				}else{
					$data['published'] = 1;
				}
				$this->DepartmentModel->update_department($id, $ownerid, $data);
			}
			redirect('departments');
		}
		else
		{
			$data = [];
			if ($id!=0){
				$department = $this->DepartmentModel->get_department($id, $ownerid);
				$data['department'] = $department[0];
			}
			$this->load->view('templates/header');
			$this->load->view('templates/sidebar-menu');
			$this->load->view('employee/add_department', $data);
			$this->load->view('templates/footer');
		}

		
	}

	public function delete_departments(){

		if(!empty($_POST))
		{
			$ids = $this->input->post('id');
			$this->DepartmentModel->delete_departments($ids);

			redirect('departments');
		}
	}

	public function update_department_status(){
		$id = $this->input->post('id');
		$update_status = $this->input->post('published');
		$data = $this->DepartmentModel->update_department_status($id, $update_status);
		echo json_encode($data);
	}

}
