<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class DataboxesKDS extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('dashboard/DashboardKDS_model');
        $this->load->library('Formatslist');
    }
    
    function kdsdisplay() {
        if($this->input->post('displayids')) {
//            $DisplayIds    =   str_replace(',',"','",$this->input->post('displayids'));
            $ArrDisplayIds    =   explode(",",$this->input->post('displayids'));
            if($ArrDisplayIds) {
                $msg='';
                foreach($ArrDisplayIds as $Arrdisplayid) {
                    $recordexists       =   $this->DashboardKDS_model->kitchenticketexists($Arrdisplayid);
                    if($recordexists>0) {
                        $Recorderdet        =   $this->DashboardKDS_model->kitchenordersdetails($Arrdisplayid);
                        $Recorderprepdet    =   $this->DashboardKDS_model->kitchenorderprepdetails($Arrdisplayid);
                        $percentageorder    =   ($Recorderdet->ORDERCLOSED/$Recorderdet->ORDERTOTAL)*100;
                        $mintime            =   $this->convertminhours($Recorderprepdet->MINIMUMPREPTIME);
                        $maxtime            =   $this->convertminhours($Recorderprepdet->MAXIMUMPREPTIME);
                        $avgtime            =   $this->convertminhours($Recorderprepdet->AVERAGEPREPTIME);
                        $msg        =   $msg.'<div class="col-lg-6 col-sm-6 col-xs-12">
                            <h5 class="row-title"><i class="fa fa-cutlery blue"></i> '.$Arrdisplayid.'</h5>
                            <div class="databox radius-bordered databox-shadowed databox-graded databox-vertical">
                                <div class="databox-top no-padding ">
                                    <div class="databox-row">
                                        <div class="databox-cell cell-3 text-align-center bg-green" style="background-color: #219a1f !important;">
                                            <span class="databox-number">'.$Recorderdet->ORDERSEND.'</span>
                                            <span class="databox-text">'.$this->lang->line("ORDERSSEND").'</span>
                                        </div>
                                        <div class="databox-cell cell-3 text-align-center bg-green" style="background-color: #357d12 !important;">
                                            <span class="databox-number">'.$Recorderdet->ORDERATTENDED.'</span>
                                            <span class="databox-text">'.$this->lang->line("ORDERSATTENDED").'</span>
                                        </div>
                                        <div class="databox-cell cell-3 text-align-center bg-green" style="background-color: #2b630c !important;">
                                            <span class="databox-number">'.$Recorderdet->ORDERCLOSED.'</span>
                                            <span class="databox-text">'.$this->lang->line("ORDERSFINISHED").'</span>
                                        </div>
                                        <div class="databox-cell cell-3 text-align-center bg-green" style="background-color: #064005 !important;">
                                            <span class="databox-number">'.$Recorderdet->ORDERTOTAL.'</span>
                                            <span class="databox-text">'.$this->lang->line("TOTALORDERS").'</span>
                                        </div>
                                    </div>
                                    <div class="databox-row">
                                        <div class="databox-cell cell-4 text-align-center bg-blueberry">
                                            <span class="databox-number">'.$mintime.'</span>
                                            <span class="databox-text">'.$this->lang->line("MINPREPTIME").'</span>
                                        </div>
                                        <div class="databox-cell cell-4 text-align-center bg-gold">
                                            <span class="databox-number">'.$maxtime.'</span>
                                            <span class="databox-text">'.$this->lang->line("MAXPREPTIME").'</span>
                                        </div>
                                        <div class="databox-cell cell-4 text-align-center bg-silver">
                                            <span class="databox-number">'.$avgtime.'</span>
                                            <span class="databox-text">'.$this->lang->line("AVGPREPTIME").'</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="databox-bottom btprogress" style="margin-top: 25px;">
                                    <span class="databox-text">'.$this->lang->line("DELIVERYPERCENT").'</span>
                                    <div class="progress progress-sm">
                                        <div class="progress-bar progress-bar-orange" role="progressbar" aria-valuenow="'.$percentageorder.'" aria-valuemin="0" aria-valuemax="100" style="width:'.$percentageorder.'%">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>';
                    }
                }
                echo $msg;
            }
        }
    }
    function convertminhours($pminutes='') {
        if($pminutes<60) {
            return (int)$pminutes.'<span style="font-size:11px"> Minutes</span>';
        } else {
            $hours  =   floor($pminutes/60);
            $mins   =   $pminutes%60;
            return (int)$hours.'<span style="font-size:11px"> Hours</span>'.(int)$mins.'<span style="font-size:11px"> Minutes</span>';
        }
    }
        
    function Topsellitem() {
        if($this->input->post('displayids')) {
            $ArrDisplayIds    =   explode(",",$this->input->post('displayids'));
            if($ArrDisplayIds) {
                $msg='';
                foreach($ArrDisplayIds as $Arrdisplayid) {
                    $msg.='<div class="databox-bottom no-padding bg-sky">
                        <div class="databox-row row-4 bg-yellow text-align-left">
                            <span class="databox-text" style="font-size:20px;margin: 0px 6px 0px;">'.$Arrdisplayid.'</span>
                        </div>';
                        $Recitemdet    =   $this->DashboardKDS_model->kitchentoporderitems($Arrdisplayid,$this->input->post('limit'));
                        if($Recitemdet) {
                            foreach($Recitemdet as $Recitem) {
                                $msg.='<div class="databox-row row-1 padding-5 padding-left-30 text-align-left bordered-bottom bordered-whitesmoke">
                                    <div class="databox-cell cell-8">
                                        <span class="databox-title no-margin">'.$Recitem->NAME.'</span>
                                    </div>
                                    <div class="databox-cell cell-4">
                                        <span class="databox-number">'.$Recitem->TOTALUNITS.'</span>
                                    </div>
                                </div>';
                            }
                        }
                    $msg.='</div>';
                    
                }
                echo $msg;
            }
        }
    }
    
}