<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class databoxes extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('dashboard/databoxes_model');
            $this->load->library('Formatslist');
    }
    
    function currentsequence()
    {
        $data = array();
        $rows = $this->databoxes_model->currentsequence();
        foreach ($rows as $row)
        {
        array_push($data, array(
            'host' => $row->HOST,
            'sequence' => $row->HOSTSEQUENCE,
            'datestart' => $this->formatslist->datetimeFormat($row->DATESTART),
            'dateend' => $this->formatslist->datetimeFormat($row->DATEEND),
            'totalamount' => $this->formatslist->formatCurrency($row->TOTALAMOUUNT),
                ));
        }
        echo json_encode($data);
    }

    function salestotal()
    {
        $data = array();
        $total = $this->databoxes_model->salestotal();
        array_push($data, array(
            'salestotal' => $this->formatslist->formatCurrency($total->SALESTOTAL),
            'salescount' => $total->SALESCOUNT
                ));
        echo json_encode($data);
    }
        
    function salesbycashier() {
    $data = array();
        $rows = $this->databoxes_model->salesbycashier();
        $cashiers=array();
        
         foreach ($rows as $row)
            array_push($cashiers, array(
                'cashier' => $row->CASHIER,
                'datestart' => $row->STARTDATE,
                'dateend' => $row->ENDDATE,
                'total' => $this->formatslist->formatCurrency($row->TOTAL)
            ));

        echo json_encode($cashiers);
    }
    
    function lastreceipts()
    {
        if($this->input->post('count'))
            $count=$this->input->post('count');
        else
            $count=5;
        $data = array();
        $rows = $this->databoxes_model->lastreceipts($count);
        $receipts=array();
        
        foreach ($rows as $row)
            array_push($receipts, array(
                'ticketid' => $row->TICKETNO,
                'date' => $row->TICKETDATE,
                'total' => $this->formatslist->formatCurrency($row->TOTAL),
                'units' => $row->QTY,
                'customer' => ($row->CUSTOMER!=null?', '.$row->CUSTOMER:'')
            ));

        echo json_encode($receipts);
    }
    
    function lastrefunds()
    {
        if($this->input->post('count'))
            $count=$this->input->post('count');
        else
            $count=5;
        $data = array();
        $rows = $this->databoxes_model->lastrefunds($count);
        $receipts=array();
        
        foreach ($rows as $row)
            array_push($receipts, array(
                'ticketid' => $row->TICKETNO,
                'date' => $row->TICKETDATE,
                'total' => $this->formatslist->formatCurrency($row->TOTAL),
                'units' => $row->QTY,
                'customer' => ($row->CUSTOMER!=null?', '.$row->CUSTOMER:'')
            ));

        echo json_encode($receipts);
    }
    
    function stockvaluebywarehouse()
    {
        $data = array();
        $rows = $this->databoxes_model->stockvalue();
        foreach ($rows as $row)
        {
        array_push($data, array(
            'total' => $this->formatslist->formatCurrency($row->TOTAL),
            'location' => $row->LOCATION
                ));
        }
        echo json_encode($data);
    }
    
    function stockvalue()
    {
        $data = array();
        $row = $this->databoxes_model->stockvalue();
        
        if($row)
        {
        array_push($data, array(
            'total' => $this->formatslist->formatCurrency($row->TOTAL),
            'locations' => $row->LOCATIONS
                ));
        }
        echo json_encode($data);
        
    }
    
    function payments()
    {
        $data[0] = array();
        $data[1] = array();
        $rows = $this->databoxes_model->payments();
        foreach ($rows as $row)
        {
        array_push($data[0], array(
            'total' => $this->formatslist->formatCurrency($row->TOTAL),
            'payment' => $row->PAYMENT,
            'notes' => ($row->NOTES!=null?' - '.$row->NOTES:'')
                ));
        }
        
        $rowtotal = $this->databoxes_model->paymentstotal();
        array_push($data[1], array(
            'total' => $this->formatslist->formatCurrency($rowtotal->TOTAL),
            'payments' => $rowtotal->PAYMENTS
                ));
        echo json_encode($data);
    }
    
    function stockin() {
        if($this->input->post('count'))
            $count=$this->input->post('count');
        else
            $count=5;
        $data = array();
        $rows = $this->databoxes_model->stockin($count);
        $stockdata=array();
        if($rows) {
            foreach ($rows as $row)
                array_push($stockdata, array(
                    'date' => $row->DATE,
                    'reason' => $row->REASON,
                    'location' => $row->LOCATION,
                    'name' => $row->NAME,
                    'unit' => $row->UNITS,
                    'price' => $this->formatslist->formatCurrency($row->PRICE),
                    'stock' => $row->STOCK,
                    'cost' => $this->formatslist->formatCurrency($row->COST)
                ));
        }
        echo json_encode($stockdata);
    }
    
    
    function stockout()
    {
        if($this->input->post('count'))
            $count=$this->input->post('count');
        else
            $count=5;
        $data = array();
        $rows = $this->databoxes_model->stockout($count);
        $stockdata=array();
        if($rows)
        {
        foreach ($rows as $row)
            array_push($stockdata, array(
                'date' => $row->DATE,
                'reason' => $row->REASON,
                'location' => $row->LOCATION,
                'name' => $row->NAME,
                'unit' => $row->UNITS,
                'price' => $this->formatslist->formatCurrency($row->PRICE),
                'stock' => $row->STOCK,
                'cost' => $this->formatslist->formatCurrency($row->COST)
            ));
        }
        echo json_encode($stockdata);
    }
    
    function abcanalysis()
    {
        if($this->input->post('count'))
            $count=$this->input->post('count');
        else
            $count=10;
        if($this->input->post('days'))
            $days=$this->input->post('days');
        else
            $days=365;
        
        
        $datefrom = date('y:m:d', strtotime("-".$days." days"));
        $data = array();
        $rows = $this->databoxes_model->abcanalysis_list($count, $datefrom);
        $sum = $this->databoxes_model->abcanalysis_total($count, $datefrom);
        $stockdata=array();
        foreach ($rows as $row)
            array_push($stockdata, array(
                'name' => $row->NAME,
                'units' => $row->UNITS,
                'cost' => $this->formatslist->formatCurrency($row->COST),
                'costpct' => $this->formatslist->formatCurrency(($row->COST/$sum->TOTALCOST)*100),
                'totalcost' => $this->formatslist->formatCurrency($sum->TOTALCOST)
            ));
        
        echo json_encode($stockdata);
    }

    function weeklysales()
    {
     $Today=date('y:m:d');

     $datefrom = Date('Y-m-d', strtotime("-6 days"));
     $dateto = Date('Y-m-d', strtotime("-5 days"));
     $data[0]['date']=date('D', strtotime($datefrom));
     $data[0]['total']=$this->formatslist->formatCurrency($this->databoxes_model->weeklysales($datefrom,$dateto));
     
     $datefrom = Date('Y-m-d', strtotime("-5 days"));
     $dateto = Date('Y-m-d', strtotime("-4 days"));
     $data[1]['date']=date('D', strtotime($datefrom));
     $data[1]['total']=$this->formatslist->formatCurrency($this->databoxes_model->weeklysales($datefrom,$dateto));
     
     $datefrom = Date('Y-m-d', strtotime("-4 days"));
     $dateto = Date('Y-m-d', strtotime("-3 days"));
     $data[2]['date']=date('D', strtotime($datefrom));
     $data[2]['total']=$this->formatslist->formatCurrency($this->databoxes_model->weeklysales($datefrom,$dateto));
     
     $datefrom = Date('Y-m-d', strtotime("-3 days"));
     $dateto = Date('Y-m-d', strtotime("-2 days"));
     $data[3]['date']=date('D', strtotime($datefrom));
     $data[3]['total']=$this->formatslist->formatCurrency($this->databoxes_model->weeklysales($datefrom,$dateto));
     
     $datefrom = Date('Y-m-d', strtotime("-2 days"));
     $dateto = Date('Y-m-d', strtotime("-1 days"));
     $data[4]['date']=date('D', strtotime($datefrom));
     $data[4]['total']=$this->formatslist->formatCurrency($this->databoxes_model->weeklysales($datefrom,$dateto));
     
     $datefrom = Date('Y-m-d', strtotime("-1 days"));
     $dateto = Date('Y-m-d');
     $data[5]['date']=date('D', strtotime($datefrom));
     $data[5]['total']=$this->formatslist->formatCurrency($this->databoxes_model->weeklysales($datefrom,$dateto));
     
     $datefrom = Date('Y-m-d');
     $dateto = Date('Y-m-d', strtotime("+1 days"));
     $data[6]['date']='';
     $data[6]['total']=$this->formatslist->formatCurrency($this->databoxes_model->weeklysales($datefrom,$dateto));
     
     echo json_encode($data);
     
    }
    
    
    function topproducts()
    {
        if($this->input->post('count'))
            $count=$this->input->post('count');
        else
            $count=5;
        $data = array();
        $rows = $this->databoxes_model->topproducts($count);
        $stockdata=array();
        if($rows)
        {
        foreach ($rows as $row)
            array_push($stockdata, array(
                'name' => $row->NAME,
                'units' => $row->UNITS,
                'total' => $this->formatslist->formatCurrency($row->TOTAL)
                
            ));
        }
        echo json_encode($stockdata);
    }
}